﻿using System;
using System.Collections.Generic;
using Microsoft.OData.Edm;
using PpmsDataService.Models;

namespace PpmsDataService.Configuration
{
    using Microsoft.Web.Http;
    using Microsoft.Web.OData.Builder;
    using System.Web.OData.Builder;

    /// <summary>
    /// Represents the model configuration for orders.
    /// </summary>
    public class FacilityModelConfiguration : IModelConfiguration
    {
        /// <summary>
        /// Applies model configurations using the provided builder for the specified API version.
        /// </summary>
        /// <param name="builder">The <see cref="ODataModelBuilder">builder</see> used to apply configurations.</param>
        /// <param name="apiVersion">The <see cref="ApiVersion">API version</see> associated with the <paramref name="builder"/>.</param>
        public void Apply( ODataModelBuilder builder, ApiVersion apiVersion )
        {
            //Set all the Entity Types here
            builder.EntitySet<Facility>("Facilities").EntityType.HasKey(p => p.StationNumber);

            if ( apiVersion <= ApiVersions.V1 )
            {
                builder.Function("GetFacilityByCity").ReturnsFromEntitySet<Facility>("Facilities").Parameter<string>("City");
                builder.Function("GetFacilityByState").ReturnsFromEntitySet<Facility>("Facilities").Parameter<string>("State");
                builder.Function("GetFacilityByRegion").ReturnsFromEntitySet<Facility>("Facilities").Parameter<string>("Region");
                builder.Function("GetFacilityByZipCode").ReturnsFromEntitySet<Facility>("Facilities").Parameter<string>("Zip");

            }
            else if ( apiVersion == ApiVersions.V2 )
            {
                
            }
            else if ( apiVersion == ApiVersions.V3 )
            {
                
            }
        }
    }
}